//[BotStacks Chat SDK](../../../index.md)/[ai.botstacks.sdk.state](../index.md)/[MemberRole](index.md)

# MemberRole

[common]\
enum [MemberRole](index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[MemberRole](index.md)&gt; 

The role of a User Member of a Chat

## Entries

| | |
|---|---|
| [Owner](-owner/index.md) | [common]<br>[Owner](-owner/index.md)<br>An Owner, has total permisisonal control over a Chat |
| [Admin](-admin/index.md) | [common]<br>[Admin](-admin/index.md)<br>An Admin, has near total permissional control over a Chat |
| [Member](-member/index.md) | [common]<br>[Member](-member/index.md)<br>A member can send Messages and read Messages from a Chat |
| [Invited](-invited/index.md) | [common]<br>[Invited](-invited/index.md)<br>An Invite sent to a User for a Chat. The User can join the Chat if invited, even if the Chat is private |
| [RejectedInvite](-rejected-invite/index.md) | [common]<br>[RejectedInvite](-rejected-invite/index.md)<br>A User that rejected an Invite to a Chat. Retained in order to prevent multiple Invites |
| [Kicked](-kicked/index.md) | [common]<br>[Kicked](-kicked/index.md)<br>A User that was kicked from a group Chat. Retained in order to prevent the User rejoining the Chat. |
| [Unknown](-unknown/index.md) | [common]<br>[Unknown](-unknown/index.md) |

## Properties

| Name | Summary |
|---|---|
| [entries](entries.md) | [common]<br>val [entries](entries.md): [EnumEntries](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.enums/-enum-entries/index.html)&lt;[MemberRole](index.md)&gt;<br>Returns a representation of an immutable list of all enum entries, in the order they're declared. |

## Functions

| Name | Summary |
|---|---|
| [valueOf](value-of.md) | [common]<br>fun [valueOf](value-of.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [MemberRole](index.md)<br>Returns the enum constant of this type with the specified name. The string must match exactly an identifier used to declare an enum constant in this type. (Extraneous whitespace characters are not permitted.) |
| [values](values.md) | [common]<br>fun [values](values.md)(): [Array](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-array/index.html)&lt;[MemberRole](index.md)&gt;<br>Returns an array containing the constants of this enum type, in the order they're declared. |
